<?php
/**
 * Recent Post: Grid Three
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $_current_widget_instance;
?>
<div <?php post_class( 'recent-post grid-item col-md-4 col-sm-6 col-xs-12' ); ?>>
	<div class="inbox">
		<?php if ( 'show' === $_current_widget_instance['thumbnail'] && $image_url = Pojo_Thumbnails::get_post_thumbnail_url( array( 'width' => '600', 'height' => '420', 'crop' => true, 'placeholder' => true ) ) ) : ?>
			<figure class="image-link">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark">
					<img src="<?php echo $image_url; ?>" alt="<?php echo esc_attr( get_the_title() ); ?>" class="media-object" />
					<div class="overlay-image"></div>
					<div class="overlay-title">
						<?php if ( 'show' === $_current_widget_instance['metadata_readmore'] ) : ?>
							<figcaption><?php echo  ! empty( $_current_widget_instance['text_readmore_mode'] ) ? $_current_widget_instance['text_readmore_mode'] : __( 'Read More &raquo;', 'pojo' ); ?></figcaption>
						<?php endif; ?>
					</div>
					<?php if ( 'show' === $_current_widget_instance['metadata_date'] ) : ?>
						<span class="entry-date">
							<time datetime="<?php the_time('o-m-d'); ?>" class="entry-date-inner date published updated">
								<span class="entry-date-day"><?php the_time( 'd' ); ?></span>
								<span class="entry-date-month"><?php the_time( 'M' ); ?></span>
							</time>
						</span>
					<?php endif; ?>
				</a>
			</figure>
		<?php endif; ?>
		<div class="caption">
			<div class="entry-meta">
				<?php if ( 'show' === $_current_widget_instance['metadata_time'] ) : ?>
					<span class="entry-time"><?php echo get_the_time(); ?></span>
				<?php endif; ?>
				<?php if ( 'show' === $_current_widget_instance['metadata_comments'] ) : ?>
					<span class="entry-comment"><?php comments_popup_link( __( 'No Comments', 'pojo' ), __( 'One Comment', 'pojo' ), __( '% Comments', 'pojo' ), 'comments' ); ?></span>
				<?php endif; ?>
				<?php if ( 'show' === $_current_widget_instance['metadata_author'] ) : ?>
					<span class="entry-user vcard author"><a class="fn" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" rel="author"><?php echo get_the_author(); ?></a></span>
				<?php endif; ?>
			</div>
			<?php if ( 'show' === $_current_widget_instance['show_title'] ) : ?>
				<h4 class="grid-heading entry-title">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a>
				</h4>
			<?php endif; ?>
			<?php if ( 'show' === $_current_widget_instance['except'] ) : ?>
				<div class="entry-excerpt">
					<p><?php echo pojo_get_words_limit( get_the_excerpt(), $_current_widget_instance['except_length_words'] ); ?></p>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>